//

// Fragment shader for sepia effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;

uniform vec4 textureRect;

varying vec2 gUV;

void main(void)
{
	if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        vec4 texel = texture2DRect(texUnit, gUV);
        // Convert to grayscale using NTSC conversion weights
        float gray = dot(texel.rgb, vec3(0.299, 0.587, 0.114)); 

         // convert grayscale to sepia
        gl_FragColor =  modulateColor * vec4(gray * vec3(1.2, 1.0, 0.8), texture2DRect(texUnit, gUV).a);
    }
    
}

